/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2008
*  ALL RIGHTS RESERVED
*
*  File Name: usr_entry.c
*                                                                          
*  Purpose: This file is for a USB Mass-Storage Device bootloader.  This file 
*           is the initial entry point for the bootloader
*                                                                          
*  Assembler:  Codewarrior for ColdFire V7.0
*                                            
*  Version:  1.3
*                                                                          
*                                                                          
*  Author: Derek Snell                             
*                                                                                       
*  Location: Indianapolis, IN. USA                                            
*                                                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.06.10  Derek Snell   Initial version
* 1.1   2008.06.30  Derek Snell	  Ported from JM128
* 1.2	2008.09.25	David Seymour Fixed jump vector in RAM target
* 1.3	2008.09.26	Derek Snell	  Added check for User entry vector in flash
* 
*
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#include "Bootloader_V2.h"
#include "support_common.h"

extern asm void asm_startmeup(void);
extern byte __SRAM[];		


void _Entry(void)
{
   byte i;
   dword* UserEntryCheck;
   
  MCF_GPIO_DDRNQ &= ~MCF_GPIO_DDRNQ_DDRNQ5;		// PNQ5 as Input
  MCF_GPIO_PNQPAR &= ~(MCF_GPIO_PNQPAR_PNQPAR5(3));		// set PNQ5 as GPIO
  
  // delay some time for GPIO stable
  for(i=0;i<3;i++) {
    
    asm(nop);
  }
 
  // If SW1 on PORTNQ5 not pressed, jump to user application
  if(MCF_GPIO_SETNQ & MCF_GPIO_SETNQ_SETNQ5) 
  {
	    if ((uint32)_Entry >= (uint32)(__SRAM)) 	// Test to see if running in RAM or Flash
	  	{
	  	     asm (JMP asm_startmeup);      // jump to user entry	  		
	  	}
		else {
		     UserEntryCheck = (dword*)USER_ENTRY_ADDRESS;
		     if(*UserEntryCheck == 0x4E714EF9) 			// check there is a valid jump op-code
		     {
			     UserEntryCheck++;						// increment pointer to next long word
			     if(*UserEntryCheck != 0xFFFFFFFF) 		// check there is a valid jump vector
			     {
		  		     asm (JMP USER_ENTRY_ADDRESS);      // jump to user entry	
			     }
		     }
		}
  } 
  

  // Disable Software Watchdog Timer
  MCF_SCM_CWCR = 0;
  

  // Enable debug 
  MCF_GPIO_PDDPAR = 0x0F;

  MCF_CLOCK_OCLR = 0xC0;   //turn on crystal
	
  // delay some time for oscillator stable
  for(i=0;i<255;i++) {
    
  		asm(nop);
  }
  MCF_CLOCK_CCLR = 0x00;    //switch to crystal 
  MCF_CLOCK_OCHR = 0x00; //turn off relaxation osc

  // Enable on-chip modules to access internal SRAM 
  MCF_SCM_RAMBAR = (0
    	| MCF_SCM_RAMBAR_BA(MIN_RAM1_ADDRESS)
    	| MCF_SCM_RAMBAR_BDE);

    
  Bootloader_Main();
}